import Link from 'next/link';
import { Button } from '@/components/ui/button';
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { ArrowLeft, BookText, Package, ListOrdered, Settings, Palette, Webhook, Code, CreditCard, Image as ImageIcon } from 'lucide-react';
import AdminNav from '@/components/admin-nav';

export default function DocumentationPage() {
  return (
    <div className="max-w-7xl mx-auto p-4 md:p-6">
      <div className="flex items-center gap-4 mb-6">
        <Link href="/">
          <Button variant="outline" size="icon">
            <ArrowLeft className="h-4 w-4" />
          </Button>
        </Link>
        <h1 className="text-3xl font-bold">Documentação</h1>
      </div>

      <AdminNav />

      <div className="space-y-8">
        <Card>
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <BookText className="h-6 w-6" />
              Bem-vindo ao Painel do seu Cardápio Digital!
            </CardTitle>
            <CardDescription>
              Este é o seu guia para gerenciar e personalizar cada aspecto do seu cardápio.
            </CardDescription>
          </CardHeader>
          <CardContent>
            <p>Utilize a navegação acima para acessar as diferentes seções de gerenciamento. Abaixo, você encontrará uma explicação detalhada de cada uma delas.</p>
          </CardContent>
        </Card>

        <Card>
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <Package className="h-6 w-6" />
              Gerenciar Produtos e Imagens
            </CardTitle>
            <CardDescription>
              Adicione, edite e remova categorias, produtos, adicionais e imagens.
            </CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div>
                <h3 className="font-semibold text-lg">Categorias</h3>
                <p className="text-muted-foreground">
                    - Para adicionar uma nova categoria (ex: "Sobremesas"), use o campo "Adicionar Nova Categoria" no topo da página.
                    <br />
                    - Para remover uma categoria, clique no botão <span className="font-mono text-sm bg-muted px-1.5 py-0.5 rounded">Remover Categoria</span> ao lado do nome da categoria. Cuidado, isso removerá todos os produtos dentro dela!
                </p>
            </div>
            <div>
                <h3 className="font-semibold text-lg">Produtos</h3>
                <p className="text-muted-foreground">
                    - Para adicionar um novo produto, preencha o formulário "Adicionar Novo Produto". Selecione a categoria correta e preencha nome, preço e descrição.
                    <br/>
                    - Para editar um produto, clique no botão <span className="font-mono text-sm bg-muted px-1.5 py-0.5 rounded">Editar Produto</span> no card do item desejado. Os campos se tornarão editáveis.
                    <br/>
                    - Para salvar, clique em <span className="font-mono text-sm bg-muted px-1.5 py-0.5 rounded">Salvar</span>. Para descartar as alterações, clique em <span className="font-mono text-sm bg-muted px-1.5 py-0.5 rounded">Cancelar</span>.
                    <br/>
                    - Para remover, clique em <span className="font-mono text-sm bg-muted px-1.5 py-0.5 rounded">Remover Produto</span>.
                </p>
            </div>
             <div className="space-y-2">
                <h3 className="font-semibold text-lg flex items-center gap-2"><ImageIcon className="h-5 w-5" />Imagens dos Produtos</h3>
                <p className="text-muted-foreground">
                    - Você pode adicionar ou alterar a imagem de um produto colando a URL da imagem no campo "URL da Imagem", tanto ao criar um novo produto quanto ao editar um existente.
                    <br/>
                    - Você pode hospedar suas imagens em serviços gratuitos como <Link href="https://imgur.com/upload" target="_blank" className="text-primary underline">Imgur</Link> ou <Link href="https://postimages.org/" target="_blank" className="text-primary underline">Postimage</Link> e colar o link direto aqui.
                </p>
                 <p className="text-sm text-muted-foreground p-3 bg-muted/50 rounded-lg">
                    <span className="font-bold">Dica de Ouro:</span> Para a melhor aparência em todas as telas, recomendamos os seguintes tamanhos de imagem:
                    <br/>
                    - <span className="font-semibold">Imagens de Produto:</span> Use uma proporção quadrada, como <span className="font-mono">500x500</span> pixels.
                    <br/>
                    - <span className="font-semibold">Imagens do Carrossel:</span> Use uma proporção de <span className="font-mono">1200x500</span> pixels (mais retangular) para um visual cinematográfico.
                </p>
            </div>
            <div>
                <h3 className="font-semibold text-lg">Adicionais</h3>
                <p className="text-muted-foreground">
                    - Dentro de cada card de produto, há um pequeno formulário para "Adicionar Adicional". Preencha o nome (ex: "Extra Bacon") e o preço, e clique no botão para adicionar.
                    <br />
                    - Para remover um adicional, clique no ícone de "X" ao lado do nome dele.
                </p>
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <ListOrdered className="h-6 w-6" />
              Visualizar Pedidos
            </CardTitle>
            <CardDescription>
              Acompanhe os pedidos dos seus clientes em tempo real.
            </CardDescription>
          </CardHeader>
          <CardContent>
            <p className="text-muted-foreground">
                Nesta página, cada pedido recebido aparecerá como um item em uma lista. Você pode clicar em cada pedido para expandir e ver todos os detalhes, incluindo os itens, o endereço de entrega e a forma de pagamento escolhida pelo cliente. Os pedidos são ordenados do mais recente para o mais antigo.
            </p>
          </CardContent>
        </Card>

        <Card>
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <Settings className="h-6 w-6" />
              Configurações
            </CardTitle>
            <CardDescription>
              Personalize a aparência, os pagamentos e as integrações do seu cardápio.
            </CardDescription>
          </CardHeader>
          <CardContent className="space-y-6">
             <div>
                <h3 className="font-semibold text-lg flex items-center gap-2"><Palette/>Cores e Aparência</h3>
                <p className="text-muted-foreground">
                   - Altere a URL da sua logo e personalize a paleta de cores (primária, fundo, texto, etc.) para que o cardápio tenha a cara da sua marca.
                   <br/>
                   - Use o seletor de cores visual ou digite o valor HSL (matiz, saturação, luminosidade) diretamente no campo de texto para um ajuste fino.
                </p>
            </div>
             <div>
                <h3 className="font-semibold text-lg flex items-center gap-2"><CreditCard/>Pagamentos (Mercado Pago)</h3>
                <p className="text-muted-foreground">
                   - Insira sua "Public Key" do Mercado Pago para preparar seu cardápio para futuras integrações de pagamento direto no site.
                </p>
            </div>
             <div>
                <h3 className="font-semibold text-lg flex items-center gap-2"><Webhook/>Automações (Webhook)</h3>
                <p className="text-muted-foreground">
                   - Se você usa sistemas de automação como n8n ou Zapier, pode inserir uma URL de webhook aqui. A cada novo pedido, os dados serão enviados para essa URL, permitindo que você crie integrações personalizadas.
                </p>
            </div>
             <div>
                <h3 className="font-semibold text-lg flex items-center gap-2"><Code/>Marketing e Rastreamento</h3>
                <p className="text-muted-foreground">
                   - Adicione os scripts do Pixel do Facebook, Google Tag Manager e Google Analytics para rastrear o comportamento dos usuários, otimizar campanhas de marketing e obter insights valiosos sobre seus clientes. Basta colar os códigos fornecidos por essas plataformas nos campos correspondentes.
                </p>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}
